clc;
close all;
%% Load 10 identical simulated Hoevers coarse crackles here 
load SC1_Hoevers
load SC2_Hoevers
load SC3_Hoevers
load SC4_Hoevers
load SC5_Hoevers
load SC6_Hoevers
load SC7_Hoevers
load SC8_Hoevers
load SC9_Hoevers
load SC10_Hoevers
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SC1_Hoevers     = [zeros(1,1000),SC1_Hoevers,zeros(1,Signal_length-(1000+length(SC1_Hoevers)))];
SC2_Hoevers     = [zeros(1,3000),SC2_Hoevers,zeros(1,Signal_length-(3000+length(SC2_Hoevers)))];
SC3_Hoevers     = [zeros(1,7000),SC3_Hoevers,zeros(1,Signal_length-(7000+length(SC3_Hoevers)))];
SC4_Hoevers     = [zeros(1,12000),SC4_Hoevers,zeros(1,Signal_length-(12000+length(SC4_Hoevers)))];
SC5_Hoevers     = [zeros(1,14000),SC5_Hoevers,zeros(1,Signal_length-(14000+length(SC5_Hoevers)))];
SC6_Hoevers     = [zeros(1,17000),SC6_Hoevers,zeros(1,Signal_length-(17000+length(SC6_Hoevers)))];
SC7_Hoevers     = [zeros(1,20000),SC7_Hoevers,zeros(1,Signal_length-(20000+length(SC7_Hoevers)))];
SC8_Hoevers     = [zeros(1,23000),SC8_Hoevers,zeros(1,Signal_length-(23000+length(SC8_Hoevers)))];
SC9_Hoevers     = [zeros(1,27500),SC9_Hoevers,zeros(1,Signal_length-(27500+length(SC9_Hoevers)))];
SC10_Hoevers    = [zeros(1,30000),SC10_Hoevers,zeros(1,Signal_length-(30000+length(SC10_Hoevers)))];
Ten_identical_simulated_Hoevers_coarse_crackles     = SC1_Hoevers+SC2_Hoevers+SC3_Hoevers+SC4_Hoevers+SC5_Hoevers+SC6_Hoevers+SC7_Hoevers+SC8_Hoevers+SC9_Hoevers+SC10_Hoevers;
Ten_identical_simulated_Hoevers_coarse_crackles     = Ten_identical_simulated_Hoevers_coarse_crackles(1:end);
%% Plot
figure
plot(Ten_identical_simulated_Hoevers_coarse_crackles,'k');
xlabel('Number of samples','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
%%
text(1150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(250,.85,'SC1-H','fontsize',8,'FontWeight','bold')
text(3150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(3150,.85,'SC2-H','fontsize',8,'FontWeight','bold')
text(7150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(7000,.85,'SC3-H','fontsize',8,'FontWeight','bold')
text(12150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(11150,.85,'SC4-H','fontsize',8,'FontWeight','bold')
text(14150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(14150,.85,'SC5-H','fontsize',8,'FontWeight','bold')
text(17150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(17150,.85,'SC6-H','fontsize',8,'FontWeight','bold')
text(20150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(20150,.85,'SC7-H','fontsize',8,'FontWeight','bold')
text(23150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(23150,.85,'SC8-H','fontsize',8,'FontWeight','bold')
text(27650,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(26500,.85,'SC9-H','fontsize',8,'FontWeight','bold')
text(30150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(29800,.85,'SC10-H','fontsize',8,'FontWeight','bold')
%%
set(gcf, 'Position',  [100, 300, 800, 300])
title('10 identical simulated Hoevers coarse crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');
xlim([0 Signal_length]);
ylim([-1 1]);
